function Kx_nom = Nominal_controller(A,B,D1)

[n,m] = size(B);
Cx = eye(n);

gamma = 0.6;

% solve LMI
setlmis([]);

% parameter matrix
P = lmivar(1,[n,1]); 
M1 = lmivar(2,[m,n]); 

% lmi 1
lmiterm([-1 1 1 P], 1, 1);
lmiterm([1 1 1 0], 0);

% lmi 2
lmiterm([2 1 1 P], 1, A, 's');
lmiterm([2 1 1 M1], B, 1, 's');
lmiterm([2 1 2 0], D1);
lmiterm([2 1 3 P], 1, Cx');
 
lmiterm([2 2 2 0], -gamma);
lmiterm([2 3 3 0], -gamma);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
lmis = getlmis;

[tmin, xfeasp] = feasp(lmis);
P = dec2mat(lmis,  xfeasp, P);
M1 = dec2mat(lmis,  xfeasp, M1);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
Kx_nom = M1*inv(P);


